/*
 *	TEST
 */

#include <stddef.h>
#include <math.h>
#include "test.h"

#define	USE_FLOAT

typedef unsigned int	fuzzyval_t;

#ifdef	USE_FLOAT
typedef struct {
	fuzzyval_t	x,y;
	double		d,s;
} Point;
#endif

static Point	k0m0[] = {
	{   0,  255, 0, 0}, 
	{  85,  255, 0, 0}, 
	{ 127,    0, 0, 0}, 
	{ 255,    0, 0, 0}
};

static Point	k0m1[] = {
	{   0,    0, 0, 0}, 
	{  85,    0, 0, 0}, 
	{ 127,  255, 0, 0}, 
	{ 170,    0, 0, 0}, 
	{ 255,    0, 0, 0}
};

static Point	k0m2[] = {
	{   0,    0, 0, 0}, 
	{ 127,    0, 0, 0}, 
	{ 170,  255, 0, 0}, 
	{ 255,  255, 0, 0}
};

static Point	k1m3[] = {
	{   0,  255, 0, 0}, 
	{  42,  255, 0, 0}, 
	{ 105,    0, 0, 0}, 
	{ 255,    0, 0, 0}
};

static Point	k1m4[] = {
	{   0,    0, 0, 0}, 
	{  42,    0, 0, 0}, 
	{ 106,  255, 0, 0}, 
	{ 170,    0, 0, 0}, 
	{ 255,    0, 0, 0}
};

static Point	k1m5[] = {
	{   0,    0, 0, 0}, 
	{ 106,    0, 0, 0}, 
	{ 170,  255, 0, 0}, 
	{ 233,    0, 0, 0}, 
	{ 255,    0, 0, 0}
};

static Point	k1m6[] = {
	{   0,    0, 0, 0}, 
	{ 170,    0, 0, 0}, 
	{ 233,  255, 0, 0}, 
	{ 255,  255, 0, 0}
};


static fuzzyval_t	m[15];
static fuzzyval_t	x[52];


#ifdef	USE_FLOAT
static double
wfu( Point * a, Point * o, fuzzyval_t ymax )
{
	double	y = (double) (a->y < ymax ? a->y : ymax);

	return y * (o->x - a->x);
}
static double
wfd( Point * a, Point * o, fuzzyval_t ymax )
{
	double	y = (double) (o->y < ymax ? o->y : ymax);

	return y * (o->x - a->x);
}
static double
sfu( register Point * a, register Point * o, double s )
{
	register double	y = (s > o->y) ? (double) (o->y - a->y) : (s - a->y);

	return (double) a->y * (o->x - a->x) +
		y * ((o->y - a->y) - y/2) / o->d;
}
static double
sfd( register Point * a, register Point * o, double s )
{
	register double	y = (s > a->y) ? (double) (a->y - o->y) : (s - o->y);

	return (double) o->y * (o->x - a->x) +
		y * ((a->y - o->y) - y/2) / -o->d;
}
static double
gs( register Point * a, register Point * o )
{
	if( a->y == o->y )
		return (double) (o->x + a->x) / 2;
	else if( a->y < o->y )
		return a->x + (double) (o->x - a->x) *
				(double)(2 * (o->y - a->y) + 3 * a->y) /
				(double)(3 * (o->y - a->y) + 6 * a->y);
	return a->x + (double) (o->x - a->x) *
			(double)(a->y - o->y + 3 * o->y) /
			(double)(3 * (a->y - o->y) + 6 * o->y);
}
static void
sgs( register Point * p, register int size )
{
	p->s = 0; p++;
	while( --size > 0 ) {
		p->s = gs(p-1,p);
		p++;
	}
}
static void
sd( register Point * p, register int size )
{
	p->d = 0; p++;
	while( --size > 0 ) {
		p->d = ((double) p->y - (double) p[-1].y) /
			((double) p->x - p[-1].x);
		p++;
	}
}
static fuzzyval_t
f( register fuzzyval_t x, register Point * p, register int size )
{
	fuzzyval_t	ax;

	for(;;) {
		if( (ax = p->x) == x )
			return p->y;
		else if( ax > x )
			return (fuzzyval_t)(0.5 + (x - p[-1].x) * p->d + p[-1].y);
		p++;
	}
}
static void
df( register const fuzzyval_t v, register Point * p, register const size, double * tfl, double * tpr )
{
	register Point	*lp;
	register int	d;
	int		i;
	double		s, ef, fl = *tfl, pr = *tpr;

	lp = p++;
	for(i = 1; i < size; i++, p++) {
		s = p->s;
		if( (d = p->y - lp->y) == 0 ) {
			fl += (ef = wfu( lp, p, v ));
			pr += ef * s;
		} else if( d > 0 && v <= lp->y ) {
			s = (double) (p->x + lp->x) / 2.0;
			fl += (ef = wfu( lp, p, v ));
			pr += ef * s;
		} else if( d < 0 && v <= p->y ) {
			s = (double) (p->x + lp->x) / 2.0;
			fl += (ef = wfd( lp, p, v ));
			pr += ef * s;
		} else if( d > 0 && v >= p->y ) {
			fl += (ef = sfu( lp, p, v ));
			pr += ef * s;
		} else if( d < 0 && v >= lp->y ) {
			fl += (ef = sfd( lp, p, v ));
			pr += ef * s;
		} else if( d > 0 ) {
			s = (p->x + lp->x) / 2.0 +
			    (v - lp->y) / (double) (p->y - lp->y) *
			    (s - (double) (p->x + lp->x) / 2.0);
			fl += (ef = sfu( lp, p, v ));
			pr += ef * s;
		} else {
			s = (p->x + lp->x) / 2.0 -
			    (v - p->y) / (double) (lp->y - p->y) *
			    ((double) (p->x + lp->x) / 2.0 - s);
			fl += (ef = sfd( lp, p, v ));
			pr += ef * s;
		}
		lp = p;
	}
	*tfl = fl;
	*tpr = pr;
}
#endif
static fuzzyval_t
fi( register fuzzyval_t x, register unsigned char * p )
{
	if( x < p[1] ) {
		if( x <= p[0] )	return 0;
		if( p[5] == 0 ) return (x - p[0]) * p[4];
		return ((((x - p[0]) * p[4]) >> (p[5] - 1)) + 1) >> 1;
	}
	if( x <= p[2] )	return (256-1);
	if( x >= p[3] )	return 0;
	if( p[7] == 0 )	return (p[3] - x) * p[6];
	return ((((p[3] - x) * p[6]) >> (p[7] - 1)) + 1) >> 1;
}

int	TESTInit( void )
{
	sd( k0m0, 4 );
	sd( k0m1, 5 );
	sd( k0m2, 4 );
	sd( k1m3, 4 );
	sd( k1m4, 5 );
	sd( k1m5, 5 );
	sd( k1m6, 4 );
	return 1;
}

void	TESTTerminate( void ) {	return;	}


int	TESTEvaluate( stell_t Pressure, stell_t Temperature, stell_t * Valve, stell_t * Valve2 )
{
	register fuzzyval_t	v;
	fuzzyval_t		xval, yval;
	unsigned long		za, ne;
#ifdef	USE_FLOAT
	double			pr, fl;
#endif

	if( Pressure < 0.00000000000000000000 || Pressure > 255.00000000000000000000 )	return 0;
	v = (fuzzyval_t) ((Pressure-(0.00000000000000000000))/1.00000000000000000000);
	m[0] = f( v, k0m0, 4 );
	m[1] = f( v, k0m1, 5 );
	m[2] = f( v, k0m2, 4 );
	if( Temperature < 0.00000000000000000000 || Temperature > 255.00000000000000000000 )	return 0;
	v = (fuzzyval_t) ((Temperature-(0.00000000000000000000))/1.00000000000000000000);
	m[3] = f( v, k1m3, 4 );
	m[4] = f( v, k1m4, 5 );
	m[5] = f( v, k1m5, 5 );
	m[6] = f( v, k1m6, 4 );

	m[7] = 0;
	x[0] = 0;
	x[1] = 255;
	x[1] = m[6] < x[1] ? m[6] : x[1];
	x[1] = m[0] < x[1] ? m[0] : x[1];
	x[0] = (fuzzyval_t) (x[1] * 0.40000000000000000000 + 0.5);
	if( x[0] > m[7] ) m[7] = x[0];
	x[2] = 0;
	x[3] = 255;
	x[3] = m[5] < x[3] ? m[5] : x[3];
	x[3] = m[1] < x[3] ? m[1] : x[3];
	x[2] = (fuzzyval_t) (x[3] * 0.40000000000000000000 + 0.5);
	if( x[2] > m[7] ) m[7] = x[2];
	x[4] = 0;
	x[5] = 255;
	x[5] = m[6] < x[5] ? m[6] : x[5];
	x[5] = m[1] < x[5] ? m[1] : x[5];
	x[4] = (fuzzyval_t) (x[5] * 0.60000000000000000000 + 0.5);
	if( x[4] > m[7] ) m[7] = x[4];
	x[6] = 0;
	x[7] = 255;
	x[7] = m[2] < x[7] ? m[2] : x[7];
	x[7] = m[4] < x[7] ? m[4] : x[7];
	x[6] = (fuzzyval_t) (x[7] * 0.40000000000000000000 + 0.5);
	if( x[6] > m[7] ) m[7] = x[6];
	x[8] = 0;
	x[9] = 255;
	x[9] = m[5] < x[9] ? m[5] : x[9];
	x[9] = m[2] < x[9] ? m[2] : x[9];
	x[8] = (fuzzyval_t) (x[9] * 0.60000000000000000000 + 0.5);
	if( x[8] > m[7] ) m[7] = x[8];
	x[10] = 255;
	x[10] = m[2] < x[10] ? m[2] : x[10];
	x[10] = m[6] < x[10] ? m[6] : x[10];
	if( x[10] > m[7] ) m[7] = x[10];
	m[8] = 0;
	x[11] = 255;
	x[11] = m[5] < x[11] ? m[5] : x[11];
	x[11] = m[1] < x[11] ? m[1] : x[11];
	if( x[11] > m[8] ) m[8] = x[11];
	m[9] = 0;
	x[12] = 255;
	x[12] = m[1] < x[12] ? m[1] : x[12];
	x[12] = m[4] < x[12] ? m[4] : x[12];
	if( x[12] > m[9] ) m[9] = x[12];
	m[10] = 0;
	x[13] = 255;
	x[13] = m[3] < x[13] ? m[3] : x[13];
	x[13] = m[0] < x[13] ? m[0] : x[13];
	if( x[13] > m[10] ) m[10] = x[13];
	x[14] = 0;
	x[15] = 255;
	x[15] = m[4] < x[15] ? m[4] : x[15];
	x[15] = m[0] < x[15] ? m[0] : x[15];
	x[14] = (fuzzyval_t) (x[15] * 0.80000000000000000000 + 0.5);
	if( x[14] > m[10] ) m[10] = x[14];
	x[16] = 0;
	x[17] = 255;
	x[17] = m[5] < x[17] ? m[5] : x[17];
	x[17] = m[0] < x[17] ? m[0] : x[17];
	x[16] = (fuzzyval_t) (x[17] * 0.40000000000000000000 + 0.5);
	if( x[16] > m[10] ) m[10] = x[16];
	x[18] = 0;
	x[19] = 255;
	x[19] = m[6] < x[19] ? m[6] : x[19];
	x[19] = m[0] < x[19] ? m[0] : x[19];
	x[18] = (fuzzyval_t) (x[19] * 0.20000000000000000000 + 0.5);
	if( x[18] > m[10] ) m[10] = x[18];
	x[20] = 0;
	x[21] = 255;
	x[21] = m[1] < x[21] ? m[1] : x[21];
	x[21] = m[3] < x[21] ? m[3] : x[21];
	x[20] = (fuzzyval_t) (x[21] * 0.60000000000000000000 + 0.5);
	if( x[20] > m[10] ) m[10] = x[20];
	x[22] = 0;
	x[23] = 255;
	x[23] = m[1] < x[23] ? m[1] : x[23];
	x[23] = m[4] < x[23] ? m[4] : x[23];
	x[22] = (fuzzyval_t) (x[23] * 0.40000000000000000000 + 0.5);
	if( x[22] > m[10] ) m[10] = x[22];
	x[24] = 0;
	x[25] = 255;
	x[25] = m[2] < x[25] ? m[2] : x[25];
	x[25] = m[3] < x[25] ? m[3] : x[25];
	x[24] = (fuzzyval_t) (x[25] * 0.40000000000000000000 + 0.5);
	if( x[24] > m[10] ) m[10] = x[24];
	m[11] = 0;
	x[26] = 0;
	x[27] = 255;
	x[27] = m[6] < x[27] ? m[6] : x[27];
	x[27] = m[0] < x[27] ? m[0] : x[27];
	x[26] = (fuzzyval_t) (x[27] * 0.40000000000000000000 + 0.5);
	if( x[26] > m[11] ) m[11] = x[26];
	x[28] = 0;
	x[29] = 255;
	x[29] = m[5] < x[29] ? m[5] : x[29];
	x[29] = m[1] < x[29] ? m[1] : x[29];
	x[28] = (fuzzyval_t) (x[29] * 0.40000000000000000000 + 0.5);
	if( x[28] > m[11] ) m[11] = x[28];
	x[30] = 0;
	x[31] = 255;
	x[31] = m[6] < x[31] ? m[6] : x[31];
	x[31] = m[1] < x[31] ? m[1] : x[31];
	x[30] = (fuzzyval_t) (x[31] * 0.60000000000000000000 + 0.5);
	if( x[30] > m[11] ) m[11] = x[30];
	x[32] = 0;
	x[33] = 255;
	x[33] = m[2] < x[33] ? m[2] : x[33];
	x[33] = m[4] < x[33] ? m[4] : x[33];
	x[32] = (fuzzyval_t) (x[33] * 0.40000000000000000000 + 0.5);
	if( x[32] > m[11] ) m[11] = x[32];
	x[34] = 0;
	x[35] = 255;
	x[35] = m[5] < x[35] ? m[5] : x[35];
	x[35] = m[2] < x[35] ? m[2] : x[35];
	x[34] = (fuzzyval_t) (x[35] * 0.60000000000000000000 + 0.5);
	if( x[34] > m[11] ) m[11] = x[34];
	x[36] = 255;
	x[36] = m[2] < x[36] ? m[2] : x[36];
	x[36] = m[6] < x[36] ? m[6] : x[36];
	if( x[36] > m[11] ) m[11] = x[36];
	m[12] = 0;
	x[37] = 255;
	x[37] = m[5] < x[37] ? m[5] : x[37];
	x[37] = m[1] < x[37] ? m[1] : x[37];
	if( x[37] > m[12] ) m[12] = x[37];
	m[13] = 0;
	x[38] = 255;
	x[38] = m[1] < x[38] ? m[1] : x[38];
	x[38] = m[4] < x[38] ? m[4] : x[38];
	if( x[38] > m[13] ) m[13] = x[38];
	m[14] = 0;
	x[39] = 255;
	x[39] = m[3] < x[39] ? m[3] : x[39];
	x[39] = m[0] < x[39] ? m[0] : x[39];
	if( x[39] > m[14] ) m[14] = x[39];
	x[40] = 0;
	x[41] = 255;
	x[41] = m[4] < x[41] ? m[4] : x[41];
	x[41] = m[0] < x[41] ? m[0] : x[41];
	x[40] = (fuzzyval_t) (x[41] * 0.80000000000000000000 + 0.5);
	if( x[40] > m[14] ) m[14] = x[40];
	x[42] = 0;
	x[43] = 255;
	x[43] = m[5] < x[43] ? m[5] : x[43];
	x[43] = m[0] < x[43] ? m[0] : x[43];
	x[42] = (fuzzyval_t) (x[43] * 0.40000000000000000000 + 0.5);
	if( x[42] > m[14] ) m[14] = x[42];
	x[44] = 0;
	x[45] = 255;
	x[45] = m[6] < x[45] ? m[6] : x[45];
	x[45] = m[0] < x[45] ? m[0] : x[45];
	x[44] = (fuzzyval_t) (x[45] * 0.20000000000000000000 + 0.5);
	if( x[44] > m[14] ) m[14] = x[44];
	x[46] = 0;
	x[47] = 255;
	x[47] = m[1] < x[47] ? m[1] : x[47];
	x[47] = m[3] < x[47] ? m[3] : x[47];
	x[46] = (fuzzyval_t) (x[47] * 0.60000000000000000000 + 0.5);
	if( x[46] > m[14] ) m[14] = x[46];
	x[48] = 0;
	x[49] = 255;
	x[49] = m[1] < x[49] ? m[1] : x[49];
	x[49] = m[4] < x[49] ? m[4] : x[49];
	x[48] = (fuzzyval_t) (x[49] * 0.40000000000000000000 + 0.5);
	if( x[48] > m[14] ) m[14] = x[48];
	x[50] = 0;
	x[51] = 255;
	x[51] = m[2] < x[51] ? m[2] : x[51];
	x[51] = m[3] < x[51] ? m[3] : x[51];
	x[50] = (fuzzyval_t) (x[51] * 0.40000000000000000000 + 0.5);
	if( x[50] > m[14] ) m[14] = x[50];

	pr = fl = 0;
	if( (v = m[7]) > 0 ) { pr += v * 0.0; fl += v; }
	if( (v = m[8]) > 0 ) { pr += v * 84.0; fl += v; }
	if( (v = m[9]) > 0 ) { pr += v * 170.0; fl += v; }
	if( (v = m[10]) > 0 ) { pr += v * 255.0; fl += v; }
	if( fl )	*Valve = 0.00000000000000000000 + (1.00000000000000000000) * floor( pr / fl + 0.5 );
	pr = fl = 0;
	if( (v = m[11]) > 0 ) { pr += v * 0.0; fl += v; }
	if( (v = m[12]) > 0 ) { pr += v * 84.0; fl += v; }
	if( (v = m[13]) > 0 ) { pr += v * 170.0; fl += v; }
	if( (v = m[14]) > 0 ) { pr += v * 255.0; fl += v; }
	if( fl )	*Valve2 = 0.00000000000000000000 + (1.00000000000000000000) * floor( pr / fl + 0.5 );
	return 1;
}
