/*
 *	Sample source code for the usage of the portable code file
 *	TransferTech, 1995
 */
#include <stdio.h>
#include "psim.h"

static BYTE		Datenfeld[1892];
static VALUE	InVars[2], 
				OutVars[2] = { 123, 222 };

/*
 *	main
 */
int	main( int argc, char *argv[] )
{
	FILE	*fp;
	int		Pressure, Temperature;
	
	if( argc != 2 ) {
		printf( "usage: fuzzytst filename\n" );
		return -1;
	}
	if( (fp = fopen( argv[1], "rb" )) == NULL ) {
		printf( "Cannot open file %s.\n", argv[1] );
		return -1;
	}
	fread( Datenfeld, 1, sizeof(Datenfeld), fp );
	if( ferror( fp ) ) {
		printf( "Error reading file %s.\n", argv[1] );
		return -1;
	}
	fclose( fp );
	if( !FuzzyInit( Datenfeld, sizeof(Datenfeld) ) )	return -2;
	for( Pressure = 0, Temperature = 0; Pressure < 256 && Temperature < 256; Pressure += 16, Temperature += 16 ) {
		InVars[0] = (VALUE) Pressure;
		InVars[1] = (VALUE) Temperature;
		if( !FuzzyEvaluate( InVars, OutVars ) )	return -3;
		printf( "%3d %3d: %3d\n", InVars[0], InVars[1], OutVars[0] );
	}
	FuzzyTerminate();
	return 0;
}
