/*-----------------------------------------
   READLOG.C Modul

   Example of a DLL for the FCM
   This DLL opens a file named METHAN.LOG
   and offers the values read out of it 
   to the FCM.

   (C) TransferTech GmbH, Braunschweig
  -----------------------------------------*/


#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include "fcmdll.h"


#define	EXPORT	_export

#define NUMCHANNELS 2

#define CH_TEMPERATURE 1
#define CH_PRESSURE 2


static FCMDLLINFO FAR LogChannelInfo [NUMCHANNELS] =
    {{"Temperature", CH_TEMPERATURE, CH_IN, 256},
     {"Pressure",   CH_PRESSURE,    CH_IN, 256}};


static FILE *LogFile;


/*----------------------------------------------------------------
   Funktion: DLLInfo

   This function offers the FCM informations to the data channels
   of this DLL.

   Parameter:
       LPINT nDLLChannels - Pointer to the number of data-channels

   Result:
       LPFCMDLLINFO       - Pointer to the description of the 
                            data-channels
  ----------------------------------------------------------------*/
LPFCMDLLINFO EXPORT CALLBACK DLLInfo (LPINT nDLLChannels)
    {
    *nDLLChannels = NUMCHANNELS;
    return LogChannelInfo;
    }


/*----------------------------------------------------------------
   Function: DLLOpen

   This function opens the data-channel with number nChannel.

   Parameter:
       WORD nChannel - Number of channel to open

   Result:
       BOOL          - TRUE  Channel opened succesfully
                       FALSE Error opening the channel
  ----------------------------------------------------------------*/
BOOL EXPORT CALLBACK DLLOpen (WORD nChannel)
    {
    if (LogFile != NULL)
        return TRUE;

    LogFile = fopen ("METHAN.LOG", "r");
    return LogFile != NULL;
    }


/*----------------------------------------------------------------
   Function: DLLClose

   This function closes the data-channel with number nChannel.

   Parameter:
       WORD nChannel - Number of channel to close

   Result:
       BOOL          - TRUE  Channel closed succesfully
                       FALSE Error closing the channel
  ----------------------------------------------------------------*/
BOOL EXPORT CALLBACK DLLClose (WORD nChannel)
    {
    if (LogFile == NULL)
        return TRUE;

    if (0 != fclose (LogFile))
        return FALSE;

    LogFile = NULL;
    return TRUE;
    }


/*----------------------------------------------------------------
   Function: DLLRead

   This function reads a value from the data-channel with 
   number nChannel.

   Parameter:
       WORD nChannel - Number of channel to read

   Result:
       unsigned long - ULONG_MAX          Error reading a value
                       [0, ULONG_MAX - 1] Value read
  ----------------------------------------------------------------*/
unsigned long EXPORT CALLBACK DLLRead (WORD nChannel)
    {
    static unsigned long nTimesRead = 0;
    static unsigned long nVolume;
    static unsigned long nPressure;

    if ((nTimesRead % NUMCHANNELS) == 0)
        {
        static char szLine [255];
        static char *End;

        if (NULL == fgets (szLine, 255, LogFile))
            return ULONG_MAX;

        nPressure = strtoul (szLine, &End, 10);
        nVolume = strtoul (End, &End, 10);
        }

    nTimesRead++;

    switch (nChannel)
        {
        case CH_TEMPERATURE:
            return nVolume;
        case CH_PRESSURE:
            return nPressure;
        }
    return ULONG_MAX;
    }


/*----------------------------------------------------------------
   Function: DLLWrite

   THis function writes a value in the data-channel with
   number nChannel.

   Parameter:
       WORD nChannel         - Number of channel to write to

       unsigned long ulValue - Value to write

   Result:
       BOOL                  - TRUE  Data written succesfully
                               FALSE Error in writing data
  ----------------------------------------------------------------*/
BOOL EXPORT CALLBACK DLLWrite (WORD nInfo, unsigned long ulValue)
    {
    return FALSE;
    }


int FAR PASCAL LibMain (HANDLE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine)
    {
    return 1;
    }

