/*
 *	luftdata.c
 *	DLL for testing the system to blow up ballons.
 *	TransferTech GmbH, Braunschweig 1992
 */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include "fcmdll.h"

#define	EXPORT	_export

#define	NUMCHANNELS	3
#define	NUMINCHANNELS	2
#define NUMOUTCHANNELS	1

#define	CH_VOLUME	1
#define	CH_PRESSURE	2
#define	CH_OUTPUT	3


static FCMDLLINFO FAR	LogChannelInfo[NUMCHANNELS] = {
	{"Volume", CH_VOLUME,   CH_IN,  4096},
	{"Pressure",   CH_PRESSURE, CH_IN,  4096},
	{"Output", CH_OUTPUT,   CH_OUT, 4096}
};


static FILE *fp_in = NULL;
static FILE *fp_out = NULL;
static char szPathName[128];
static char filein[128];
static char fileout[128];


/*----------------------------------------------------------------
   Function: DLLInfo

   This function delivers informations to the FCM about the apropriate
   data-channels in this DLL .

   Parameter:
       LPINT nDLLChannels - Pointer to the number of datenchannels

   Result:
       LPFCMDLLINFO       - Pointer to the description of the
                            data-channels
  ----------------------------------------------------------------*/
LPFCMDLLINFO EXPORT CALLBACK DLLInfo( LPINT nDLLChannels )
{
	*nDLLChannels = NUMCHANNELS;
	return LogChannelInfo;
}


/*----------------------------------------------------------------
   Function: DLLOpen

   This function opens the data-channel with number nChannel.

   Parameter:
       WORD nChannel - Number of channel to open

   Result:
       BOOL          - TRUE  Channel opened succesfully
                       FALSE Error opening the channel
  ----------------------------------------------------------------*/
BOOL EXPORT CALLBACK DLLOpen( WORD nChannel )
{
	switch( nChannel ) {
	case CH_PRESSURE:
	case CH_VOLUME:
		if( fp_in != NULL )	return TRUE;
		fp_in = fopen( filein, "r" );
		return fp_in != NULL;
	case CH_OUTPUT:
		if( fp_out != NULL )	return TRUE;
		fp_out = fopen( fileout, "w" );
		return fp_out != NULL;
	}
	return FALSE;
}


/*----------------------------------------------------------------
   Function: DLLClose

   This function closes the data-channel with number nChannel.

   Parameter:
       WORD nChannel - Number of channel to close

   Result:
       BOOL          - TRUE  Channel closed succesfully
                       FALSE Error closing the channnel
  ----------------------------------------------------------------*/
BOOL EXPORT CALLBACK DLLClose( WORD nChannel )
{
	switch( nChannel ) {
	case CH_PRESSURE:
	case CH_VOLUME:
		if( fp_in == NULL )	return TRUE;
		fclose( fp_in );
		fp_in = NULL;
		return TRUE;
	case CH_OUTPUT:
		if( fp_out == NULL )	return TRUE;
		fclose( fp_out );
		fp_out = NULL;
		return TRUE;
	}
	return FALSE;
}


/*----------------------------------------------------------------
   Function: DLLRead

   This function reads a value from the data-channel with
   number nChannel.

   Parameter:
       WORD nChannel - Number of channel to read

   Result:
       unsigned long - ULONG_MAX          Error on reading
                       [0, ULONG_MAX - 1] Value read
  ----------------------------------------------------------------*/
unsigned long EXPORT CALLBACK DLLRead (WORD nChannel)
    {
    static unsigned long nTimesRead = 0;
    static unsigned long nVolume;
    static unsigned long nPressure;

    if (fp_in == NULL) return ULONG_MAX;
    if ((nTimesRead % NUMINCHANNELS) == 0)
        {
        static char szLine [255];
        static char *End;

        if (NULL == fgets (szLine, 255, fp_in))
            return ULONG_MAX;

        nPressure = strtoul (szLine, &End, 10);
        nVolume = strtoul (End, &End, 10);
        }

    nTimesRead++;

    switch (nChannel)
        {
        case CH_VOLUME:
            return nVolume;
        case CH_PRESSURE:
            return nPressure;
        }
    return ULONG_MAX;
    }


/*----------------------------------------------------------------
   Function: DLLWrite

   This function writes a value in the data-channel with 
   number nChannel.

   Parameter:
       WORD nChannel         - Number of channel to write to
       unsigned long ulValue - value to write

   Result:
       BOOL                  - TRUE  written succesfully
                               FALSE Error on writing
  ----------------------------------------------------------------*/
BOOL EXPORT CALLBACK DLLWrite (WORD nChannel, unsigned long ulValue)
{
	static char	text[80];

	if( nChannel != CH_OUTPUT )	return FALSE;
	if( fp_out == NULL )	return FALSE;
	ultoa( ulValue, text, 10 );
	lstrcat( text, "\r\n" );
	fputs( text, fp_out );
	return TRUE;
}

int CALLBACK LibMain (HANDLE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine)
    {
    char *p;

    GetModuleFileName( hInstance, szPathName, sizeof (szPathName));
    p = &szPathName[lstrlen(szPathName)-1];
    while ( p != szPathName ) {
    	if( *p != '\\' )
    		p--;
    	else {
    		p[1] = 0;
    		break;
    	}
    }
    lstrcpy( fileout, szPathName );
    lstrcat( fileout, "out.dat" );
    lstrcpy( filein, szPathName );
    lstrcat( filein, "in.dat" );
    return 1;
    }

