/*
 *	loopback.c
 *	Loopback-DLL for accessing the own results.
 *	Frank Neubauer, 1992
 */

#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <conio.h>
#include "fcmdll.h"

#define	EXPORT	_export

#define	RESOLUTION	0

#define	NUMCHANNELS	32
#define	NUMINCHANNELS	16
#define	NUMOUTCHANNELS	16
enum {
	UNUSED,
	IN1,  OUT1,
	IN2,  OUT2,
	IN3,  OUT3,
	IN4,  OUT4,
	IN5,  OUT5,
	IN6,  OUT6,
	IN7,  OUT7,
	IN8,  OUT8,
	IN9,  OUT9,
	IN10, OUT10,
	IN11, OUT11,
	IN12, OUT12,
	IN13, OUT13,
	IN14, OUT14,
	IN15, OUT15,
	IN16, OUT16
};


static FCMDLLINFO FAR	LinkChannelInfo [NUMCHANNELS];
static unsigned long	last_value[NUMINCHANNELS];
static char		szPathName[128];
static char		szLine[80];

LPFCMDLLINFO EXPORT CALLBACK DLLInfo (LPINT nDLLChannels)
{
	*nDLLChannels = NUMCHANNELS;
	return LinkChannelInfo;
}


BOOL EXPORT CALLBACK DLLOpen (WORD nChannel)
{
	return TRUE;
}


BOOL EXPORT CALLBACK DLLClose (WORD nChannel)
{
	return TRUE;
}


unsigned long EXPORT CALLBACK DLLRead (WORD nChannel)
{
	if( nChannel == 0 || nChannel > NUMCHANNELS )
		return ULONG_MAX;
	if( ( nChannel % 2 ) == 0 )
		return ULONG_MAX;
	return last_value[(nChannel-1)/2];
}


BOOL CALLBACK EXPORT DLLWrite (WORD nChannel, unsigned long ulValue)
{
	if( nChannel == 0 || nChannel > NUMCHANNELS )
		return FALSE;
	if( ( nChannel % 2 ) != 0 )
		return FALSE;
	last_value[(nChannel-1)/2] = ulValue;
	return TRUE;
}


int CALLBACK LibMain (HANDLE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine)
{
	static char	*endp;
	char	*p;
	int	i;
	FILE	*fp;

	GetModuleFileName( hInstance, szPathName, sizeof (szPathName));
	p = &szPathName[lstrlen(szPathName)-1];
	while ( p != szPathName ) {
		if( *p != '\\' )
			p--;
		else {
			p[1] = 0;
			break;
		}
	}
	lstrcat( szPathName, "loopback.dat" );
	for( i = 0; i < NUMCHANNELS; ) {
		wsprintf( LinkChannelInfo[i].szChannel, "Input %2d", 1 + i/2 );
		LinkChannelInfo[i].nChannel = i+1;
		LinkChannelInfo[i].ChannelType = CH_IN;
		LinkChannelInfo[i].nResolution = RESOLUTION;
		i++;
		wsprintf( LinkChannelInfo[i].szChannel, "Output %2d", 1 + i/2 );
		LinkChannelInfo[i].nChannel = i+1;
		LinkChannelInfo[i].ChannelType = CH_OUT;
		LinkChannelInfo[i].nResolution = RESOLUTION;
		i++;
	}
	fp = fopen( szPathName, "r" );
	if( fp != NULL ) for( i = 0; i < NUMINCHANNELS; i++ ) {
		if( NULL == fgets( szLine, sizeof( szLine ), fp ) )	break;
		last_value[i] = strtoul( szLine, &endp, 10 );
	}
	if( fp != NULL )	fclose( fp );
	return TRUE;
}


int CALLBACK	_WEP( void )
{
	FILE	*fp;
	int	i;

	if( (fp = fopen( szPathName, "w" )) == NULL )	return 1;
	for( i = 0; i < NUMINCHANNELS; i++ ) {
		ultoa( last_value[i], szLine, 10 );
		lstrcat( szLine, "\r\n" );
		fputs( szLine, fp );
	}
	fclose( fp );
	return TRUE;
}
