/*-----------------------------------------
   LINK.C Modul
   Example to connect I/O-Plug-In-Cards.
   Port-access by Library-functions
   inp, outp.

   TransferTech GmbH, 1992
  -----------------------------------------*/


#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <conio.h>
#include "fcmdll.h"

#define	EXPORT	_export

static WORD GetByte (void);
static void WriteByte (WORD);


#define NUMCHANNELS   3

#define CH_INLINK     1
#define CH_OUTLINK    2
#define	CH_LASTOUT    3

#define STATUSPORTIN  0x152
#define STATUSPORTOUT 0x153
#define DATAPORTIN    0x150
#define DATAPORTOUT   0x151
#define RESETPORT     0x160


static FCMDLLINFO FAR LinkChannelInfo [NUMCHANNELS] = {
     // Name, Number, Direction, Resolution
     {"Input Link",  CH_INLINK,  CH_IN,  4096},
     {"Output Link", CH_OUTLINK, CH_OUT, 4096},
     {"Last Output", CH_LASTOUT, CH_IN, 4096}
};
static unsigned long last_output = 0;


/*
 *	DLLInfo
 *	Delivers a pointer to the table of defined channels
 *	to the FCM.
 */
LPFCMDLLINFO EXPORT	CALLBACK DLLInfo (LPINT nDLLChannels)
    {
    *nDLLChannels = NUMCHANNELS;
    return LinkChannelInfo;
    }


/*
 *	DLLOpen
 *	The FCM wants to open the chanbel with the number nChannel
 *	This may be used to initialise the channel.
 */
BOOL EXPORT	CALLBACK DLLOpen (WORD nChannel)
    {
    return TRUE;
    }


/*
 *	DLLClose
 *	THe FCM closes the channel with the number
 *	nChannel.
 */
BOOL EXPORT	CALLBACK DLLClose (WORD nChannel)
    {
    return TRUE;
    }


/*
 *	DLLRead
 *	The FCM asks for a value for the channel
 *	nChannel. This has to be in the range of
 *	0..resolution-1 (i.e. 0-255 at a resolution
 *	of 256).
 *	A value of ULONG_MAX delivered back, which
 *	is defined in<limits.h>, shows the FCM, that no
 *	value for this channel is available.
 */
unsigned long EXPORT CALLBACK DLLRead (WORD nChannel)
    {
    if (nChannel == CH_INLINK)
        {
        DWORD InByte = GetByte (); // reject old byte

	while ((inp (STATUSPORTIN) & 1) == 0) ; // wait for new byte
        InByte = GetByte();

        if (InByte == 0)
            return 4095;
        else if ((InByte & 128) == 0)
            return 0;
        else
            return ((InByte & 0x7FUL) * 4095UL) / 127UL;
        }
    if (nChannel == CH_LASTOUT)
        return last_output;

    return ULONG_MAX; // End of data-stream
    }


static WORD GetByte (void)
    {
    static WORD InByte;

    if ((inp (STATUSPORTIN) & 1) != 0)
        InByte = inp (DATAPORTIN);
    return InByte;
    }


/*
 *	DLLWrite
 *	The FCM writes a value to a channel.
 */
BOOL EXPORT	CALLBACK DLLWrite (WORD nChannel, unsigned long ulValue)
    {
    if (nChannel == CH_OUTLINK)
        {
        last_output = ulValue;
        // Skalierung vornehmen
        WriteByte ((WORD) (0x3fUL & ~((ulValue * 63UL) / 4095UL)));
        }
    return TRUE;
    }


static void WriteByte (WORD wValue)
    {
    if ((inp (STATUSPORTOUT) & 1) != 0)
        outp (DATAPORTOUT, LOBYTE (wValue));
    }


/*
 *	LibMain
 *	Initialising part of the Library.
 *	Is called on loading.
 */
int CALLBACK LibMain (HINSTANCE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine)
    {
    int i;

    outp (RESETPORT, 1);
    for (i = 0; i < 200; i++);
    outp (RESETPORT, 0);
    return 1;
    }

