/*
 *	dlltest.c
 *	Program for testing a DLL.
 *	(c) TransferTech GmbH, 1993-1995
 */

#pragma warning (disable: 4001)

#include <windows.h>
#include <windowsx.h>
#include <limits.h>
#include "fcmdll.h"

static HINSTANCE	hInstanceMain;
static LPCSTR		szAppName = "DLLTEST";
static char			szBuffer[128];

/*
 *	ShowMessage
 */
static int	ShowMessage( LPCSTR Text, UINT Style )
{
	return MessageBox( NULL, Text, szAppName, Style );
}

/*
 *	WinMain
 */
int	PASCAL	WinMain( HINSTANCE hInstance, HINSTANCE hInstancePrev, LPSTR lpCmdLine, int nShow )
{
	HINSTANCE		hLib = NULL;
	LPFNDLLINFO		fnDLLInfo;
	LPFNDLLOPEN		fnDLLOpen;
	LPFNDLLCLOSE	fnDLLClose;
	LPFNDLLREAD		fnDLLRead;
	LPFNDLLWRITE	fnDLLWrite;
	LPFCMDLLINFO	lpChanTab;
	int				rc, n, nChanCount = 0;
	unsigned long	ulValue;
	
	hInstanceMain = hInstance;
	rc = ShowMessage( "Loading DLL...", MB_OKCANCEL );
	if( rc != IDOK )	return 0;
	hLib = LoadLibrary( lpCmdLine );
	if( hLib <= HINSTANCE_ERROR ) {
		wsprintf( szBuffer, "DLL '%s' cannot be loaded", lpCmdLine );
		ShowMessage( szBuffer, MB_OK );
		return 0;
	}
	fnDLLInfo  = (LPFNDLLINFO)  GetProcAddress( hLib, "DLLInfo" );
	fnDLLOpen  = (LPFNDLLOPEN)  GetProcAddress( hLib, "DLLOpen" );
	fnDLLClose = (LPFNDLLCLOSE) GetProcAddress( hLib, "DLLClose" );
	fnDLLRead  = (LPFNDLLREAD)  GetProcAddress( hLib, "DLLRead" );
	fnDLLWrite = (LPFNDLLWRITE) GetProcAddress( hLib, "DLLWrite" );
	if( !fnDLLInfo || !fnDLLOpen || !fnDLLClose || !fnDLLRead || !fnDLLWrite ) {
		FreeLibrary( hLib );
		ShowMessage( "Functions not found", MB_OK );
		return 0;
	}
	lpChanTab = fnDLLInfo( &nChanCount );
	for( n = 0; n < nChanCount; n++ ) {
		if( !fnDLLOpen( lpChanTab[n].nChannel ) ) {
			wsprintf( szBuffer, "Channel %u (%s) refuses opening", 
						lpChanTab[n].nChannel, lpChanTab[n].szChannel );
			ShowMessage( szBuffer, MB_OK );
			continue;
		}
		switch( lpChanTab[n].ChannelType ) {
		case CH_IN:
			ulValue = fnDLLRead( lpChanTab[n].nChannel );
			if( ulValue != ULONG_MAX ) {
				wsprintf( szBuffer, "Reading %ul from channel %s", 
						ulValue, lpChanTab[n].szChannel );
				ShowMessage( szBuffer, MB_OK );
			}
			break;
		case CH_OUT:
			ulValue = 100 + lpChanTab[n].nChannel;
			fnDLLWrite( lpChanTab[n].nChannel, ulValue );
			break;
		}
		fnDLLClose( lpChanTab[n].nChannel );
	}
	FreeLibrary( hLib );
	wsprintf( szBuffer, "DLL '%s' passed all tests sucessfully", lpCmdLine );
	ShowMessage( szBuffer, MB_OK );
	return 0;
}
