/*
 *	METHANI
 */

#include <stddef.h>
#include <math.h>
#include "methani.h"

#undef	USE_FLOAT

typedef unsigned int	fuzzyval_t;

#ifdef	USE_FLOAT
typedef struct {
	fuzzyval_t	x,y;
	double		d,s;
} Point;
#endif

static unsigned char	k0m0[] = { 0x00, 0x00, 0x55, 0x7F, 0x00, 0x00, 0xC2, 0x05 };
static unsigned char	k0m1[] = { 0x55, 0x7F, 0x7F, 0xAA, 0xC2, 0x05, 0xBE, 0x05 };
static unsigned char	k0m2[] = { 0x7F, 0xAA, 0xFF, 0xFF, 0xBE, 0x05, 0x00, 0x00 };
static unsigned char	k1m3[] = { 0x00, 0x00, 0x2A, 0x69, 0x00, 0x00, 0x82, 0x05 };
static unsigned char	k1m4[] = { 0x2A, 0x6A, 0x6A, 0xAA, 0xFF, 0x06, 0xFF, 0x06 };
static unsigned char	k1m5[] = { 0x6A, 0xAA, 0xAA, 0xE9, 0xFF, 0x06, 0x82, 0x05 };
static unsigned char	k1m6[] = { 0xAA, 0xE9, 0xFF, 0xFF, 0x82, 0x05, 0x00, 0x00 };

static fuzzyval_t	m[11];
static fuzzyval_t	x[26];


#ifdef	USE_FLOAT
static double
wfu( Point * a, Point * o, fuzzyval_t ymax )
{
	double	y = (double) (a->y < ymax ? a->y : ymax);

	return y * (o->x - a->x);
}
static double
wfd( Point * a, Point * o, fuzzyval_t ymax )
{
	double	y = (double) (o->y < ymax ? o->y : ymax);

	return y * (o->x - a->x);
}
static double
sfu( register Point * a, register Point * o, double s )
{
	register double	y = (s > o->y) ? (double) (o->y - a->y) : (s - a->y);

	return (double) a->y * (o->x - a->x) +
		y * ((o->y - a->y) - y/2) / o->d;
}
static double
sfd( register Point * a, register Point * o, double s )
{
	register double	y = (s > a->y) ? (double) (a->y - o->y) : (s - o->y);

	return (double) o->y * (o->x - a->x) +
		y * ((a->y - o->y) - y/2) / -o->d;
}
static double
gs( register Point * a, register Point * o )
{
	if( a->y == o->y )
		return (double) (o->x + a->x) / 2;
	else if( a->y < o->y )
		return a->x + (double) (o->x - a->x) *
				(double)(2 * (o->y - a->y) + 3 * a->y) /
				(double)(3 * (o->y - a->y) + 6 * a->y);
	return a->x + (double) (o->x - a->x) *
			(double)(a->y - o->y + 3 * o->y) /
			(double)(3 * (a->y - o->y) + 6 * o->y);
}
static void
sgs( register Point * p, register int size )
{
	p->s = 0; p++;
	while( --size > 0 ) {
		p->s = gs(p-1,p);
		p++;
	}
}
static void
sd( register Point * p, register int size )
{
	p->d = 0; p++;
	while( --size > 0 ) {
		p->d = ((double) p->y - (double) p[-1].y) /
			((double) p->x - p[-1].x);
		p++;
	}
}
static fuzzyval_t
f( register fuzzyval_t x, register Point * p, register int size )
{
	fuzzyval_t	ax;

	for(;;) {
		if( (ax = p->x) == x )
			return p->y;
		else if( ax > x )
			return (fuzzyval_t)(0.5 + (x - p[-1].x) * p->d + p[-1].y);
		p++;
	}
}
static void
df( register const fuzzyval_t v, register Point * p, register const size, double * tfl, double * tpr )
{
	register Point	*lp;
	register int	d;
	int		i;
	double		s, ef, fl = *tfl, pr = *tpr;

	lp = p++;
	for(i = 1; i < size; i++, p++) {
		s = p->s;
		if( (d = p->y - lp->y) == 0 ) {
			fl += (ef = wfu( lp, p, v ));
			pr += ef * s;
		} else if( d > 0 && v <= lp->y ) {
			fl += (ef = wfu( lp, p, v ));
			pr += ef * s;
		} else if( d < 0 && v <= p->y ) {
			fl += (ef = wfd( lp, p, v ));
			pr += ef * s;
		} else if( d > 0 && v >= p->y ) {
			fl += (ef = sfu( lp, p, v ));
			pr += ef * s;
		} else if( d < 0 && v >= lp->y ) {
			fl += (ef = sfd( lp, p, v ));
			pr += ef * s;
		} else if( d > 0 ) {
			s = (p->x + lp->x) / 2.0 +
			    (v - lp->y) / (double) (p->y - lp->y) *
			    (s - (double) (p->x + lp->x) / 2.0);
			fl += (ef = sfu( lp, p, v ));
			pr += ef * s;
		} else {
			s = (p->x + lp->x) / 2.0 -
			    (v - p->y) / (double) (lp->y - p->y) *
			    ((double) (p->x + lp->x) / 2.0 - s);
			fl += (ef = sfd( lp, p, v ));
			pr += ef * s;
		}
		lp = p;
	}
	*tfl = fl;
	*tpr = pr;
}
#endif
static fuzzyval_t
fi( register fuzzyval_t x, register unsigned char * p )
{
	if( x < p[1] ) {
		if( x <= p[0] )	return 0;
		return ((x - p[0]) * p[4]) >> p[5];
	}
	if( x <= p[2] )	return 1;
	if( x >= p[3] )	return 0;
	return ((p[3] - x) * p[6]) >> p[7];
}

int	METHANIInit( void )
{
	return 1;
}

void	METHANITerminate( void ) {	return;	}


int	METHANIEvaluate( int Pressure, int Temperature, int * Valve )
{
	register fuzzyval_t	v;
	fuzzyval_t		xval, yval;
	unsigned long		za, ne;
#ifdef	USE_FLOAT
	double			pr, fl;
#endif

	if( Pressure < 0 || Pressure > 255 )	return 0;
	v = (fuzzyval_t) (Pressure-(0));
	m[0] = fi( v, k0m0 );
	m[1] = fi( v, k0m1 );
	m[2] = fi( v, k0m2 );
	if( Temperature < 0 || Temperature > 255 )	return 0;
	v = (fuzzyval_t) (Temperature-(0));
	m[3] = fi( v, k1m3 );
	m[4] = fi( v, k1m4 );
	m[5] = fi( v, k1m5 );
	m[6] = fi( v, k1m6 );

	m[7] = 0;
	x[0] = 0;
	x[1] = 255;
	x[1] = m[6] < x[1] ? m[6] : x[1];
	x[1] = m[0] < x[1] ? m[0] : x[1];
	x[0] = (x[1] * 102) / 256;
	if( x[0] > m[7] ) m[7] = x[0];
	x[2] = 0;
	x[3] = 255;
	x[3] = m[5] < x[3] ? m[5] : x[3];
	x[3] = m[1] < x[3] ? m[1] : x[3];
	x[2] = (x[3] * 102) / 256;
	if( x[2] > m[7] ) m[7] = x[2];
	x[4] = 0;
	x[5] = 255;
	x[5] = m[6] < x[5] ? m[6] : x[5];
	x[5] = m[1] < x[5] ? m[1] : x[5];
	x[4] = (x[5] * 153) / 256;
	if( x[4] > m[7] ) m[7] = x[4];
	x[6] = 0;
	x[7] = 255;
	x[7] = m[2] < x[7] ? m[2] : x[7];
	x[7] = m[4] < x[7] ? m[4] : x[7];
	x[6] = (x[7] * 102) / 256;
	if( x[6] > m[7] ) m[7] = x[6];
	x[8] = 0;
	x[9] = 255;
	x[9] = m[5] < x[9] ? m[5] : x[9];
	x[9] = m[2] < x[9] ? m[2] : x[9];
	x[8] = (x[9] * 153) / 256;
	if( x[8] > m[7] ) m[7] = x[8];
	x[10] = 255;
	x[10] = m[2] < x[10] ? m[2] : x[10];
	x[10] = m[6] < x[10] ? m[6] : x[10];
	if( x[10] > m[7] ) m[7] = x[10];
	m[8] = 0;
	x[11] = 255;
	x[11] = m[5] < x[11] ? m[5] : x[11];
	x[11] = m[1] < x[11] ? m[1] : x[11];
	if( x[11] > m[8] ) m[8] = x[11];
	m[9] = 0;
	x[12] = 255;
	x[12] = m[1] < x[12] ? m[1] : x[12];
	x[12] = m[4] < x[12] ? m[4] : x[12];
	if( x[12] > m[9] ) m[9] = x[12];
	m[10] = 0;
	x[13] = 255;
	x[13] = m[3] < x[13] ? m[3] : x[13];
	x[13] = m[0] < x[13] ? m[0] : x[13];
	if( x[13] > m[10] ) m[10] = x[13];
	x[14] = 0;
	x[15] = 255;
	x[15] = m[4] < x[15] ? m[4] : x[15];
	x[15] = m[0] < x[15] ? m[0] : x[15];
	x[14] = (x[15] * 204) / 256;
	if( x[14] > m[10] ) m[10] = x[14];
	x[16] = 0;
	x[17] = 255;
	x[17] = m[5] < x[17] ? m[5] : x[17];
	x[17] = m[0] < x[17] ? m[0] : x[17];
	x[16] = (x[17] * 102) / 256;
	if( x[16] > m[10] ) m[10] = x[16];
	x[18] = 0;
	x[19] = 255;
	x[19] = m[6] < x[19] ? m[6] : x[19];
	x[19] = m[0] < x[19] ? m[0] : x[19];
	x[18] = (x[19] * 51) / 256;
	if( x[18] > m[10] ) m[10] = x[18];
	x[20] = 0;
	x[21] = 255;
	x[21] = m[1] < x[21] ? m[1] : x[21];
	x[21] = m[3] < x[21] ? m[3] : x[21];
	x[20] = (x[21] * 153) / 256;
	if( x[20] > m[10] ) m[10] = x[20];
	x[22] = 0;
	x[23] = 255;
	x[23] = m[1] < x[23] ? m[1] : x[23];
	x[23] = m[4] < x[23] ? m[4] : x[23];
	x[22] = (x[23] * 102) / 256;
	if( x[22] > m[10] ) m[10] = x[22];
	x[24] = 0;
	x[25] = 255;
	x[25] = m[2] < x[25] ? m[2] : x[25];
	x[25] = m[3] < x[25] ? m[3] : x[25];
	x[24] = (x[25] * 102) / 256;
	if( x[24] > m[10] ) m[10] = x[24];

	za = 0; ne = 0;
	if( (v = m[7]) > 0 ) { za += (unsigned) v * 0; ne += (unsigned) v; }
	if( (v = m[8]) > 0 ) { za += (unsigned) v * 84; ne += (unsigned) v; }
	if( (v = m[9]) > 0 ) { za += (unsigned) v * 170; ne += (unsigned) v; }
	if( (v = m[10]) > 0 ) { za += (unsigned) v * 255; ne += (unsigned) v; }
	if( ne )	*Valve = (int) (za / ne);
	return 1;
}
