/*
 *	METHAN
 */

#include <stddef.h>
#include <math.h>
#include "methan.h"

#define	USE_FLOAT

typedef unsigned int	fuzzyval_t;

#ifdef	USE_FLOAT
typedef struct {
	fuzzyval_t	x,y;
	double		d,s;
} Point;
#endif

static Point	k0m0[] = {
	{   0,  255, 0, 0}, 
	{  85,  255, 0, 0}, 
	{ 128,    0, 0, 0}, 
	{ 255,    0, 0, 0}
};

static Point	k0m1[] = {
	{   0,    0, 0, 0}, 
	{  85,    0, 0, 0}, 
	{ 128,  255, 0, 0}, 
	{ 170,    0, 0, 0}, 
	{ 255,    0, 0, 0}
};

static Point	k0m2[] = {
	{   0,    0, 0, 0}, 
	{ 128,    0, 0, 0}, 
	{ 170,  255, 0, 0}, 
	{ 255,  255, 0, 0}
};

static Point	k1m3[] = {
	{   0,  255, 0, 0}, 
	{  43,  255, 0, 0}, 
	{ 106,    0, 0, 0}, 
	{ 255,    0, 0, 0}
};

static Point	k1m4[] = {
	{   0,    0, 0, 0}, 
	{  43,    0, 0, 0}, 
	{ 106,  255, 0, 0}, 
	{ 170,    0, 0, 0}, 
	{ 255,    0, 0, 0}
};

static Point	k1m5[] = {
	{   0,    0, 0, 0}, 
	{ 106,    0, 0, 0}, 
	{ 170,  255, 0, 0}, 
	{ 234,    0, 0, 0}, 
	{ 255,    0, 0, 0}
};

static Point	k1m6[] = {
	{   0,    0, 0, 0}, 
	{ 170,    0, 0, 0}, 
	{ 234,  255, 0, 0}, 
	{ 255,  255, 0, 0}
};

static Point	k2m7[] = {
	{   0,  255, 0, 0}, 
	{  85,    0, 0, 0}, 
	{ 255,    0, 0, 0}
};

static Point	k2m8[] = {
	{   0,    0, 0, 0}, 
	{  85,  255, 0, 0}, 
	{ 170,    0, 0, 0}, 
	{ 255,    0, 0, 0}
};

static Point	k2m9[] = {
	{   0,    0, 0, 0}, 
	{  85,    0, 0, 0}, 
	{ 170,  255, 0, 0}, 
	{ 255,    0, 0, 0}
};

static Point	k2m10[] = {
	{   0,    0, 0, 0}, 
	{ 170,    0, 0, 0}, 
	{ 255,  255, 0, 0}
};


static fuzzyval_t	m[11];
static fuzzyval_t	x[9];


#ifdef	USE_FLOAT
static double
wfu( Point * a, Point * o, fuzzyval_t ymax )
{
	double	y = (double) (a->y < ymax ? a->y : ymax);

	return y * (o->x - a->x);
}
static double
wfd( Point * a, Point * o, fuzzyval_t ymax )
{
	double	y = (double) (o->y < ymax ? o->y : ymax);

	return y * (o->x - a->x);
}
static double
sfu( register Point * a, register Point * o, double s )
{
	register double	y = (s > o->y) ? (double) (o->y - a->y) : (s - a->y);

	return (double) a->y * (o->x - a->x) +
		y * ((o->y - a->y) - y/2) / o->d;
}
static double
sfd( register Point * a, register Point * o, double s )
{
	register double	y = (s > a->y) ? (double) (a->y - o->y) : (s - o->y);

	return (double) o->y * (o->x - a->x) +
		y * ((a->y - o->y) - y/2) / -o->d;
}
static double
gs( register Point * a, register Point * o )
{
	if( a->y == o->y )
		return (double) (o->x + a->x) / 2;
	else if( a->y < o->y )
		return a->x + (double) (o->x - a->x) *
				(double)(2 * (o->y - a->y) + 3 * a->y) /
				(double)(3 * (o->y - a->y) + 6 * a->y);
	return a->x + (double) (o->x - a->x) *
			(double)(a->y - o->y + 3 * o->y) /
			(double)(3 * (a->y - o->y) + 6 * o->y);
}
static void
sgs( register Point * p, register int size )
{
	p->s = 0; p++;
	while( --size > 0 ) {
		p->s = gs(p-1,p);
		p++;
	}
}
static void
sd( register Point * p, register int size )
{
	p->d = 0; p++;
	while( --size > 0 ) {
		p->d = ((double) p->y - (double) p[-1].y) /
			((double) p->x - p[-1].x);
		p++;
	}
}
static fuzzyval_t
f( register fuzzyval_t x, register Point * p, register int size )
{
	fuzzyval_t	ax;

	for(;;) {
		if( (ax = p->x) == x )
			return p->y;
		else if( ax > x )
			return (fuzzyval_t)(0.5 + (x - p[-1].x) * p->d + p[-1].y);
		p++;
	}
}
static void
df( register const fuzzyval_t v, register Point * p, register const size, double * tfl, double * tpr )
{
	register Point	*lp;
	register int	d;
	int		i;
	double		s, ef, fl = *tfl, pr = *tpr;

	lp = p++;
	for(i = 1; i < size; i++, p++) {
		s = p->s;
		if( (d = p->y - lp->y) == 0 ) {
			fl += (ef = wfu( lp, p, v ));
			pr += ef * s;
		} else if( d > 0 && v <= lp->y ) {
			s = (double) (p->x + lp->x) / 2.0;
			fl += (ef = wfu( lp, p, v ));
			pr += ef * s;
		} else if( d < 0 && v <= p->y ) {
			s = (double) (p->x + lp->x) / 2.0;
			fl += (ef = wfd( lp, p, v ));
			pr += ef * s;
		} else if( d > 0 && v >= p->y ) {
			fl += (ef = sfu( lp, p, v ));
			pr += ef * s;
		} else if( d < 0 && v >= lp->y ) {
			fl += (ef = sfd( lp, p, v ));
			pr += ef * s;
		} else if( d > 0 ) {
			s = (p->x + lp->x) / 2.0 +
			    (v - lp->y) / (double) (p->y - lp->y) *
			    (s - (double) (p->x + lp->x) / 2.0);
			fl += (ef = sfu( lp, p, v ));
			pr += ef * s;
		} else {
			s = (p->x + lp->x) / 2.0 -
			    (v - p->y) / (double) (lp->y - p->y) *
			    ((double) (p->x + lp->x) / 2.0 - s);
			fl += (ef = sfd( lp, p, v ));
			pr += ef * s;
		}
		lp = p;
	}
	*tfl = fl;
	*tpr = pr;
}
#endif
static fuzzyval_t
fi( register fuzzyval_t x, register unsigned char * p )
{
	if( x < p[1] ) {
		if( x <= p[0] )	return 0;
		if( p[5] == 0 ) return (x - p[0]) * p[4];
		return ((((x - p[0]) * p[4]) >> (p[5] - 1)) + 1) >> 1;
	}
	if( x <= p[2] )	return (256-1);
	if( x >= p[3] )	return 0;
	if( p[7] == 0 )	return (p[3] - x) * p[6];
	return ((((p[3] - x) * p[6]) >> (p[7] - 1)) + 1) >> 1;
}

int	METHANInit( void )
{
	sd( k0m0, 4 );
	sd( k0m1, 5 );
	sd( k0m2, 4 );
	sd( k1m3, 4 );
	sd( k1m4, 5 );
	sd( k1m5, 5 );
	sd( k1m6, 4 );
	sd( k2m7, 3 );
	sgs( k2m7, 3 );
	sd( k2m8, 4 );
	sgs( k2m8, 4 );
	sd( k2m9, 4 );
	sgs( k2m9, 4 );
	sd( k2m10, 3 );
	sgs( k2m10, 3 );
	return 1;
}

void	METHANTerminate( void ) {	return;	}


int	METHANEvaluate( stell_t Pressure, stell_t Temperature, stell_t * Valve )
{
	register fuzzyval_t	v;
	fuzzyval_t		xval, yval;
	unsigned long		za, ne;
#ifdef	USE_FLOAT
	double			pr, fl;
#endif

	if( Pressure < 37.00000000000000000000 || Pressure > 43.00000000000000000000 )	return 0;
	v = (fuzzyval_t) ((Pressure-(37.00000000000000000000))/0.02352941176470588000);
	m[0] = f( v, k0m0, 4 );
	m[1] = f( v, k0m1, 5 );
	m[2] = f( v, k0m2, 4 );
	if( Temperature < 400.00000000000000000000 || Temperature > 1000.00000000000000000000 )	return 0;
	v = (fuzzyval_t) ((Temperature-(400.00000000000000000000))/2.35294117647058800000);
	m[3] = f( v, k1m3, 4 );
	m[4] = f( v, k1m4, 5 );
	m[5] = f( v, k1m5, 5 );
	m[6] = f( v, k1m6, 4 );

	m[7] = 0;
	x[0] = 255;
	x[0] = m[5] < x[0] ? m[5] : x[0];
	x[0] = m[2] < x[0] ? m[2] : x[0];
	if( x[0] > m[7] ) m[7] = x[0];
	x[1] = 0;
	x[2] = 255;
	x[2] = m[6] < x[2] ? m[6] : x[2];
	x[2] = m[1] < x[2] ? m[1] : x[2];
	x[1] = (fuzzyval_t) (x[2] * 0.50000000000000000000 + 0.5);
	if( x[1] > m[7] ) m[7] = x[1];
	x[3] = 0;
	x[4] = 0;
	x[4] = m[2] > x[4] ? m[2] : x[4];
	x[4] = m[6] > x[4] ? m[6] : x[4];
	x[3] = (fuzzyval_t) (x[4] * 0.80000000000000000000 + 0.5);
	if( x[3] > m[7] ) m[7] = x[3];
	m[8] = 0;
	x[5] = 255;
	x[5] = m[5] < x[5] ? m[5] : x[5];
	x[5] = m[1] < x[5] ? m[1] : x[5];
	if( x[5] > m[8] ) m[8] = x[5];
	m[9] = 0;
	x[6] = 255;
	x[6] = m[1] < x[6] ? m[1] : x[6];
	x[6] = m[4] < x[6] ? m[4] : x[6];
	if( x[6] > m[9] ) m[9] = x[6];
	m[10] = 0;
	x[7] = 0;
	x[7] = m[3] > x[7] ? m[3] : x[7];
	x[7] = m[0] > x[7] ? m[0] : x[7];
	if( x[7] > m[10] ) m[10] = x[7];
	x[8] = 255;
	x[8] = m[4] < x[8] ? m[4] : x[8];
	x[8] = m[0] < x[8] ? m[0] : x[8];
	if( x[8] > m[10] ) m[10] = x[8];

	pr = fl = 0;
	if( (v = m[7]) > 0 ) df( v, k2m7, 3, &fl, &pr );
	if( (v = m[8]) > 0 ) df( v, k2m8, 4, &fl, &pr );
	if( (v = m[9]) > 0 ) df( v, k2m9, 4, &fl, &pr );
	if( (v = m[10]) > 0 ) df( v, k2m10, 3, &fl, &pr );
	if( fl )	*Valve = 0.00000000000000000000 + (0.39215686274509800000) * floor( pr / fl + 0.5 );
	return 1;
}
